/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmResources;
import svenhjol.charm.base.gui.AbstractCharmContainerScreen;
import svenhjol.charm.base.gui.CharmImageButton;
import svenhjol.charm.base.helper.MapRenderHelper;
import svenhjol.charm.container.AtlasContainer;
import svenhjol.charm.container.AtlasInventory;
import svenhjol.charm.message.ServerAtlasTransfer;

public class AtlasScreen
extends AbstractCharmContainerScreen<AtlasContainer> {
    private static final ResourceLocation CONTAINER_BACKGROUND = new ResourceLocation("charm", "textures/gui/atlas_container.png");
    private static final RenderType MAP_DECORATIONS = RenderType.func_228658_l_((ResourceLocation)new ResourceLocation("textures/map/map_icons.png"));
    private static final RenderType LINES = RenderType.func_228632_a_((String)"lines", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228728_a_(false));
    private static final int SIZE = 48;
    private static final int LEFT = 74;
    private static final int TOP = 16;
    private static final int BUTTON_SIZE = 9;
    private static final int BUTTON_DISTANCE = 3;
    private static final int CENTER = 19;
    private static final int MAX_MAPS = 8;
    private static final int NORMAL_SIZE = 128;
    private static final float BASE_SCALE = 0.375f;
    private static final int LIGHT = 240;
    private final int slot;
    private final Map<ButtonDirection, CharmImageButton> buttons;
    private final WorldMap worldMap = new WorldMap();
    private final SingleMap singleMap = new SingleMap(null);
    private final MapItemRenderer mapItemRenderer;
    private MapGui mapGui;
    private int lastSize;

    public AtlasScreen(AtlasContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn, CONTAINER_BACKGROUND);
        this.field_146999_f = 175;
        this.field_147000_g = 168;
        AtlasInventory atlasInventory = screenContainer.getAtlasInventory();
        this.slot = inv.func_184429_b(atlasInventory.getAtlasItem());
        Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = atlasInventory.getCurrentDimensionMapInfos((World)Minecraft.func_71410_x().field_71441_e);
        this.lastSize = mapInfos.size();
        this.mapGui = this.lastSize > 1 ? this.getWorldMap() : this.getSingleMap(this.lastSize == 0 ? null : mapInfos.values().iterator().next());
        this.buttons = new EnumMap<ButtonDirection, CharmImageButton>(ButtonDirection.class);
        for (ButtonDirection direction : ButtonDirection.values()) {
            this.buttons.put(direction, this.createButton(direction));
        }
        this.mapItemRenderer = Minecraft.func_71410_x().field_71460_t.func_147701_i();
    }

    private CharmImageButton createButton(ButtonDirection dir) {
        return new CharmImageButton(() -> this.field_147003_i + 74 + dir.left, () -> this.field_147009_r + 16 + dir.top, dir.width, dir.height, dir.texStart, 0, dir.height, 2 * dir.height, CharmResources.INVENTORY_BUTTONS, it -> this.mapGui.buttonClick(dir));
    }

    private static boolean isShiftClick() {
        long handle = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        return InputMappings.func_216506_a((long)handle, (int)340) || InputMappings.func_216506_a((long)handle, (int)344);
    }

    private WorldMap getWorldMap() {
        this.worldMap.fixedMapDistance = false;
        return this.worldMap;
    }

    private SingleMap getSingleMap(AtlasInventory.MapInfo mapInfo) {
        this.singleMap.mapInfo = mapInfo;
        return this.singleMap;
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.updateGui();
        this.updateButtonState();
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    @Override
    protected void func_230451_b_(MatrixStack matrices, int mouseX, int mouseY) {
        super.func_230451_b_(matrices, mouseX, mouseY);
        MapRenderHelper.renderMapWithBackground(matrices, 74, 16, 0, 0.375f, 240, bufferSource -> this.mapGui.render(matrices, (IRenderTypeBuffer.Impl)bufferSource, mouseX, mouseY));
    }

    private void updateGui() {
        Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = ((AtlasContainer)this.field_147002_h).getAtlasInventory().getCurrentDimensionMapInfos((World)Minecraft.func_71410_x().field_71441_e);
        int size = mapInfos.size();
        if (this.mapGui instanceof WorldMap) {
            if (mapInfos.size() <= 1) {
                this.changeGui(this.getSingleMap(mapInfos.isEmpty() ? null : mapInfos.values().iterator().next()));
            }
        } else if (this.mapGui instanceof SingleMap && size > this.lastSize) {
            mapInfos.values().stream().skip(size - 1).findAny().ifPresent(it -> this.changeGui(this.getSingleMap((AtlasInventory.MapInfo)it)));
        }
        this.lastSize = size;
    }

    private void updateButtonState() {
        this.buttons.forEach((direction, button) -> {
            button.field_230694_p_ = this.mapGui.buttonVisible((ButtonDirection)((Object)direction));
            if (button.field_230694_p_) {
                button.field_230693_o_ = this.mapGui.buttonEnabled((ButtonDirection)((Object)direction));
                if (!this.field_230710_m_.contains(button)) {
                    this.func_230480_a_((Widget)button);
                }
            } else {
                this.removeButton((Widget)button);
            }
        });
    }

    private void removeButton(Widget button) {
        this.field_230710_m_.remove(button);
        this.field_230705_e_.remove(button);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.mapGui.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (type == ClickType.QUICK_MOVE && slotIn.func_75211_c().func_77973_b() == Items.field_151098_aY) {
            Charm.PACKET_HANDLER.sendToServer(new ServerAtlasTransfer(this.slot, slotIn.getSlotIndex(), -1, ServerAtlasTransfer.MoveMode.FROM_INVENTORY));
        } else {
            super.func_184098_a(slotIn, slotId, mouseButton, type);
        }
    }

    private void changeGui(MapGui gui) {
        this.mapGui = gui;
    }

    private void renderDecorations(MatrixStack matrices, IRenderTypeBuffer buffer, MapData mapData, float relativeScale, Predicate<MapDecoration> filter) {
        int k = 0;
        for (MapDecoration mapdecoration : mapData.field_76203_h.values()) {
            if (!filter.test(mapdecoration) || mapdecoration.render(k)) {
                ++k;
                continue;
            }
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)((float)mapdecoration.func_176112_b() / 2.0f + 64.0f), (double)((float)mapdecoration.func_176113_c() / 2.0f + 64.0f), 0.02);
            matrices.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)mapdecoration.func_176111_d() * 22.5f));
            matrices.func_227862_a_(relativeScale * 4.0f, relativeScale * 4.0f, 3.0f);
            matrices.func_227861_a_(-0.125, 0.125, 0.0);
            byte b0 = mapdecoration.func_176110_a();
            float f1 = (float)(b0 % 16) / 16.0f;
            float f2 = (float)(b0 / 16) / 16.0f;
            float f3 = (float)(b0 % 16 + 1) / 16.0f;
            float f4 = (float)(b0 / 16 + 1) / 16.0f;
            Matrix4f matrix4f = matrices.func_227866_c_().func_227870_a_();
            IVertexBuilder builder = buffer.getBuffer(MAP_DECORATIONS);
            float z = (float)k * 0.001f;
            builder.func_227888_a_(matrix4f, -1.0f, 1.0f, z).func_225586_a_(255, 255, 255, 255).func_225583_a_(f1, f2).func_227886_a_(240).func_181675_d();
            builder.func_227888_a_(matrix4f, 1.0f, 1.0f, z).func_225586_a_(255, 255, 255, 255).func_225583_a_(f3, f2).func_227886_a_(240).func_181675_d();
            builder.func_227888_a_(matrix4f, 1.0f, -1.0f, z).func_225586_a_(255, 255, 255, 255).func_225583_a_(f3, f4).func_227886_a_(240).func_181675_d();
            builder.func_227888_a_(matrix4f, -1.0f, -1.0f, z).func_225586_a_(255, 255, 255, 255).func_225583_a_(f1, f4).func_227886_a_(240).func_181675_d();
            matrices.func_227865_b_();
            ++k;
        }
    }

    private class SingleMap
    implements MapGui {
        private final Set<ButtonDirection> supportedDirections = EnumSet.of(ButtonDirection.LEFT, ButtonDirection.TOP, ButtonDirection.RIGHT, ButtonDirection.BOTTOM, ButtonDirection.BACK);
        private AtlasInventory.MapInfo mapInfo;

        public SingleMap(AtlasInventory.MapInfo mapInfo) {
            this.mapInfo = mapInfo;
        }

        @Override
        public void render(MatrixStack matrices, IRenderTypeBuffer.Impl bufferSource, int mouseX, int mouseY) {
            MapData mapData;
            Minecraft mc = Minecraft.func_71410_x();
            ClientWorld world = mc.field_71441_e;
            if (world == null) {
                return;
            }
            if (this.mapInfo != null && (mapData = world.func_217406_a(FilledMapItem.func_219993_a((int)this.mapInfo.id))) != null) {
                matrices.func_227860_a_();
                matrices.func_227861_a_(0.0, 0.0, 1.0);
                AtlasScreen.this.mapItemRenderer.func_228086_a_(matrices, (IRenderTypeBuffer)bufferSource, mapData, true, 240);
                AtlasScreen.this.renderDecorations(matrices, (IRenderTypeBuffer)bufferSource, mapData, 2.0f, it -> true);
                matrices.func_227865_b_();
            }
        }

        @Override
        public void buttonClick(ButtonDirection direction) {
            if (direction == ButtonDirection.BACK) {
                AtlasScreen.this.changeGui(AtlasScreen.this.getWorldMap());
            } else {
                AtlasInventory inventory = ((AtlasContainer)AtlasScreen.this.field_147002_h).getAtlasInventory();
                Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = inventory.getCurrentDimensionMapInfos((World)Minecraft.func_71410_x().field_71441_e);
                AtlasInventory.MapInfo mapInfo1 = mapInfos.get(inventory.convertCoordsToIndex(this.mapInfo.x, this.mapInfo.z).plus(direction.vector));
                if (mapInfo1 != null) {
                    AtlasScreen.this.changeGui(AtlasScreen.this.getSingleMap(mapInfo1));
                }
            }
        }

        @Override
        public boolean buttonVisible(ButtonDirection direction) {
            return this.supportedDirections.contains((Object)direction);
        }

        @Override
        public boolean buttonEnabled(ButtonDirection direction) {
            AtlasInventory inventory = ((AtlasContainer)AtlasScreen.this.field_147002_h).getAtlasInventory();
            Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = inventory.getCurrentDimensionMapInfos((World)Minecraft.func_71410_x().field_71441_e);
            if (direction == ButtonDirection.BACK) {
                return this.mapInfo == null && !mapInfos.isEmpty() || mapInfos.size() > 1;
            }
            if (this.mapInfo != null) {
                return mapInfos.containsKey(inventory.convertCoordsToIndex(this.mapInfo.x, this.mapInfo.z).plus(direction.vector));
            }
            return false;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0 && (double)(AtlasScreen.this.field_147003_i + 74) <= mouseX && mouseX < (double)(AtlasScreen.this.field_147003_i + 74 + 48) && (double)(AtlasScreen.this.field_147009_r + 16) <= mouseY && mouseY < (double)(AtlasScreen.this.field_147009_r + 16 + 48)) {
                ItemStack heldItem = AtlasScreen.this.field_213127_e.func_70445_o();
                if (!heldItem.func_190926_b()) {
                    Charm.PACKET_HANDLER.sendToServer(new ServerAtlasTransfer(AtlasScreen.this.slot, -1, -1, ServerAtlasTransfer.MoveMode.FROM_HAND));
                } else if (this.mapInfo != null) {
                    if (AtlasScreen.isShiftClick()) {
                        Charm.PACKET_HANDLER.sendToServer(new ServerAtlasTransfer(AtlasScreen.this.slot, this.mapInfo.x, this.mapInfo.z, ServerAtlasTransfer.MoveMode.TO_INVENTORY));
                    } else {
                        Charm.PACKET_HANDLER.sendToServer(new ServerAtlasTransfer(AtlasScreen.this.slot, this.mapInfo.x, this.mapInfo.z, ServerAtlasTransfer.MoveMode.TO_HAND));
                    }
                    AtlasScreen.this.changeGui(AtlasScreen.this.getSingleMap(null));
                }
                return true;
            }
            return false;
        }
    }

    private class WorldMap
    implements MapGui {
        private final Collector<AtlasInventory.Index, ?, Extremes> extremesCollector = Collector.of(() -> new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE}, (acc, index) -> {
            if (acc[0] > index.x) {
                acc[0] = index.x;
            }
            if (acc[1] < index.x) {
                acc[1] = index.x;
            }
            if (acc[2] > index.y) {
                acc[2] = index.y;
            }
            if (acc[3] < index.y) {
                acc[3] = index.y;
            }
        }, (acc1, acc2) -> {
            for (int i = 0; i < 4; ++i) {
                int n = i;
                acc1[n] = acc1[n] + acc2[i];
            }
            return acc1;
        }, acc -> new Extremes(acc[0], acc[1], acc[2], acc[3]), new Collector.Characteristics[0]);
        private AtlasInventory.Index corner = null;
        private Extremes extremes = new Extremes(0, 0, 0, 0);
        private int maxMapDistance = 1;
        private int mapDistance = 1;
        private boolean fixedMapDistance = false;

        private WorldMap() {
        }

        private boolean updateExtremes() {
            AtlasInventory inventory = ((AtlasContainer)AtlasScreen.this.field_147002_h).getAtlasInventory();
            Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = inventory.getCurrentDimensionMapInfos((World)Minecraft.func_71410_x().field_71441_e);
            if (mapInfos.isEmpty()) {
                return false;
            }
            this.extremes = mapInfos.keySet().stream().collect(this.extremesCollector);
            this.maxMapDistance = this.extremes.getMaxDistance();
            if (this.maxMapDistance > 8) {
                this.maxMapDistance = 8;
            }
            int n = this.mapDistance = this.fixedMapDistance ? Math.min(this.mapDistance, this.maxMapDistance) : this.maxMapDistance;
            if (this.mapDistance < this.maxMapDistance || this.mapDistance == 8) {
                if (this.corner == null) {
                    this.corner = inventory.getIndexOf(((AtlasScreen)AtlasScreen.this).field_213127_e.field_70458_d).minus(this.mapDistance / 2).clamp(this.extremes.min, this.extremes.max.plus(1 - this.mapDistance));
                }
            } else {
                this.corner = null;
            }
            return true;
        }

        @Override
        public void render(MatrixStack matrices, IRenderTypeBuffer.Impl bufferSource, int mouseX, int mouseY) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientWorld world = mc.field_71441_e;
            if (world == null || !this.updateExtremes()) {
                return;
            }
            float mapSize = 128.0f / (float)this.mapDistance;
            float mapScale = 1.0f / (float)this.mapDistance;
            AtlasInventory.Index currentMin = this.corner != null ? this.corner : this.extremes.min;
            AtlasInventory inventory = ((AtlasContainer)AtlasScreen.this.field_147002_h).getAtlasInventory();
            Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = inventory.getCurrentDimensionMapInfos((World)Minecraft.func_71410_x().field_71441_e);
            AtlasInventory.Index playerIndex = inventory.getIndexOf(((AtlasScreen)AtlasScreen.this).field_213127_e.field_70458_d);
            for (Map.Entry<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfo : mapInfos.entrySet()) {
                MapData mapData;
                AtlasInventory.Index key = mapInfo.getKey();
                if (this.corner != null && (this.corner.x > key.x || key.x >= this.corner.x + this.mapDistance || this.corner.y > key.y || key.y >= this.corner.y + this.mapDistance) || (mapData = world.func_217406_a(FilledMapItem.func_219993_a((int)mapInfo.getValue().id))) == null) continue;
                matrices.func_227860_a_();
                matrices.func_227861_a_((double)(mapSize * (float)(key.x - currentMin.x)), (double)(mapSize * (float)(key.y - currentMin.y)), 0.1);
                matrices.func_227862_a_(mapScale, mapScale, 1.0f);
                AtlasScreen.this.mapItemRenderer.func_228086_a_(matrices, (IRenderTypeBuffer)bufferSource, mapData, false, 240);
                matrices.func_227861_a_(0.0, 0.0, 0.2);
                AtlasScreen.this.renderDecorations(matrices, (IRenderTypeBuffer)bufferSource, mapData, 1.5f * (float)this.mapDistance, it -> it.func_191179_b() != MapDecoration.Type.PLAYER_OFF_MAP && it.func_191179_b() != MapDecoration.Type.PLAYER_OFF_LIMITS && (it.func_191179_b() != MapDecoration.Type.PLAYER || key.equals(playerIndex)));
                matrices.func_227865_b_();
            }
            this.drawLines(matrices, bufferSource.getBuffer(LINES));
        }

        private void drawLines(MatrixStack matrices, IVertexBuilder builder) {
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, 0.0, 0.2);
            matrices.func_227862_a_(1.3333334f, 1.3333334f, 1.0f);
            for (int xLine = 1; xLine < this.mapDistance; ++xLine) {
                this.vLine(matrices, builder, xLine * 2 * 48 / this.mapDistance, 0, 96, -1);
            }
            for (int yLine = 1; yLine < this.mapDistance; ++yLine) {
                this.hLine(matrices, builder, 0, 96, yLine * 2 * 48 / this.mapDistance, -1);
            }
            matrices.func_227865_b_();
        }

        private void hLine(MatrixStack matrixStack, IVertexBuilder builder, int minX, int maxX, int y, int color) {
            this.fill(matrixStack, builder, minX, y, maxX + 1, y + 1, color);
        }

        private void vLine(MatrixStack matrixStack, IVertexBuilder builder, int x, int minY, int maxY, int color) {
            this.fill(matrixStack, builder, x, minY + 1, x + 1, maxY, color);
        }

        private void fill(MatrixStack matrices, IVertexBuilder builder, int minX, int minY, int maxX, int maxY, int color) {
            if (minX < maxX) {
                int i = minX;
                minX = maxX;
                maxX = i;
            }
            if (minY < maxY) {
                int j = minY;
                minY = maxY;
                maxY = j;
            }
            float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
            builder.func_227888_a_(matrix, (float)minX, (float)maxY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
            builder.func_227888_a_(matrix, (float)maxX, (float)maxY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
            builder.func_227888_a_(matrix, (float)maxX, (float)minY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
            builder.func_227888_a_(matrix, (float)minX, (float)minY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            double normX = this.normalizeForMapArea(74 + AtlasScreen.this.field_147003_i, mouseX);
            double normY = this.normalizeForMapArea(16 + AtlasScreen.this.field_147009_r, mouseY);
            if (button == 0 && 0.0 <= normX && normX < 1.0 && 0.0 <= normY && normY < 1.0) {
                ItemStack heldItem = AtlasScreen.this.field_213127_e.func_70445_o();
                if (!heldItem.func_190926_b()) {
                    Charm.PACKET_HANDLER.sendToServer(new ServerAtlasTransfer(AtlasScreen.this.slot, -1, -1, ServerAtlasTransfer.MoveMode.FROM_HAND));
                } else if (this.updateExtremes()) {
                    AtlasInventory.Index currentMin = this.corner != null ? this.corner : this.extremes.min;
                    AtlasInventory.Index index = AtlasInventory.Index.of((int)(normX * (double)this.mapDistance), (int)(normY * (double)this.mapDistance)).plus(currentMin);
                    Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = ((AtlasContainer)AtlasScreen.this.field_147002_h).getAtlasInventory().getCurrentDimensionMapInfos((World)Minecraft.func_71410_x().field_71441_e);
                    AtlasInventory.MapInfo mapInfo = mapInfos.get(index);
                    if (mapInfo != null) {
                        if (AtlasScreen.isShiftClick()) {
                            Charm.PACKET_HANDLER.sendToServer(new ServerAtlasTransfer(AtlasScreen.this.slot, mapInfo.x, mapInfo.z, ServerAtlasTransfer.MoveMode.TO_INVENTORY));
                        } else {
                            AtlasScreen.this.changeGui(AtlasScreen.this.getSingleMap(mapInfo));
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void buttonClick(ButtonDirection direction) {
            switch (direction) {
                case LEFT: 
                case TOP: 
                case RIGHT: 
                case BOTTOM: {
                    if (this.corner == null) break;
                    this.corner = this.corner.plus(direction.vector.multiply(this.mapDistance)).clamp(this.extremes.min, AtlasInventory.Index.max(this.extremes.min, this.extremes.max.plus(1 - this.mapDistance)));
                    break;
                }
                case IN: {
                    this.fixedMapDistance = true;
                    --this.mapDistance;
                    if (this.mapDistance != 1) break;
                    Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = ((AtlasContainer)AtlasScreen.this.field_147002_h).getAtlasInventory().getCurrentDimensionMapInfos((World)Minecraft.func_71410_x().field_71441_e);
                    AtlasScreen.this.changeGui(AtlasScreen.this.getSingleMap(mapInfos.get(this.corner != null ? this.corner : this.extremes.min)));
                    break;
                }
                case OUT: {
                    this.fixedMapDistance = true;
                    ++this.mapDistance;
                }
            }
        }

        @Override
        public boolean buttonVisible(ButtonDirection direction) {
            switch (direction) {
                case LEFT: 
                case TOP: 
                case RIGHT: 
                case BOTTOM: {
                    return this.corner != null;
                }
                case IN: 
                case OUT: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean buttonEnabled(ButtonDirection direction) {
            switch (direction) {
                case LEFT: {
                    return this.corner != null && this.corner.x > this.extremes.min.x;
                }
                case TOP: {
                    return this.corner != null && this.corner.y > this.extremes.min.y;
                }
                case RIGHT: {
                    return this.corner != null && this.corner.x + this.mapDistance <= this.extremes.max.x;
                }
                case BOTTOM: {
                    return this.corner != null && this.corner.y + this.mapDistance <= this.extremes.max.y;
                }
                case IN: {
                    return this.mapDistance > 1;
                }
                case OUT: {
                    return this.mapDistance < this.maxMapDistance;
                }
            }
            return false;
        }

        private double normalizeForMapArea(double base, double val) {
            return (val - base) / 48.0;
        }
    }

    private static class Extremes {
        public final AtlasInventory.Index min;
        public final AtlasInventory.Index max;

        private Extremes(int minX, int maxX, int minY, int maxY) {
            this.min = AtlasInventory.Index.of(minX, minY);
            this.max = AtlasInventory.Index.of(maxX, maxY);
        }

        public int getMaxDistance() {
            return Math.max(this.max.x + 1 - this.min.x, this.max.y + 1 - this.min.y);
        }
    }

    private static interface MapGui {
        public void render(MatrixStack var1, IRenderTypeBuffer.Impl var2, int var3, int var4);

        default public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return false;
        }

        public void buttonClick(ButtonDirection var1);

        public boolean buttonVisible(ButtonDirection var1);

        public boolean buttonEnabled(ButtonDirection var1);
    }

    private static enum ButtonDirection {
        LEFT(-12, 19, 9, 9, 77, -1, 0),
        TOP(19, -12, 9, 9, 50, 0, -1),
        RIGHT(51, 19, 9, 9, 68, 1, 0),
        BOTTOM(19, 51, 9, 9, 59, 0, 1),
        BACK(82, -12, 16, 16, 86, 0, 0),
        OUT(78, 51, 8, 9, 102, 0, 0),
        IN(86, 51, 8, 9, 110, 0, 0);

        final int left;
        final int top;
        final int width;
        final int height;
        final int texStart;
        final AtlasInventory.Index vector;

        private ButtonDirection(int left, int top, int width, int height, int texStart, int x, int y) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
            this.texStart = texStart;
            this.vector = AtlasInventory.Index.of(x, y);
        }
    }
}

